package Template;

abstract class BevandaTemplate {

	// Metodo template che definisce gli step dell'algoritmo
	public final void preparaBevanda() {
		portaAcquaEbollizione();
		preparaInfuso();
		versaInTazza();
		if (ilClienteDesideraCondimenti()) {
			aggiungiCondimenti();
		}
	}

	private void portaAcquaEbollizione() {
		System.out.println("Porta l'acqua ad ebollizione");
	}

	private void versaInTazza() {
		System.out.println("Versa nella tazza");
	}

	protected abstract void preparaInfuso();
	protected abstract void aggiungiCondimenti();

	// Metodo hook
	protected boolean ilClienteDesideraCondimenti() {
		return true;
	}
}